(*| 16:16 25/08/1996 *)
unit INFOOBJ;
{$DEFINE USE_BW}

interface

uses
  dos;

type
  cpu_info_t = record
    cpu_type : byte;
    MSW : word;
    GDT : array[1..6] of byte;
    IDT : array[1..6] of byte;
    intflag : boolean;
    ndp_type : byte;
    ndp_cw : word;
    weitek: byte;
    test_type: char
  end;

procedure CPUID(var a: cpu_info_t);

function diskread(drive: byte; starting_sector: longint;
  number_of_sectors: word; var buffer): word;

procedure longcall(addr: longint; var regs: registers);

function ATIinfo(data_in: byte; register: word): byte;

procedure AltIntr(intno: byte; var regs: registers);

procedure AltMsDos(var regs: registers);

{$IFNDEF USE_BW}
function CirrusCK: byte;

function CTICK: byte;

function TsengCK: byte;

function ZyMOSCK: byte;
{$ENDIF}

implementation

{$F+}
procedure CPUID(var a: cpu_info_t); external;

function diskread(drive: byte; starting_sector: longint;
  number_of_sectors: word; var buffer): word; external;

procedure longcall(addr: longint; var regs: registers); external;

function ATIinfo(data_in: byte; register: word): byte; external;

procedure AltIntr(intno: byte; var regs: registers); external;

procedure AltMsDos(var regs: registers); external;

{$IFNDEF USE_BW}
function CirrusCK: byte; external;

function CTICK: byte; external;

function TsengCK: byte; external;

function ZyMOSCK: byte; external;
{$ENDIF}

{$IFDEF USE_BW}
(*$L INFOBW*)
{$ELSE}
(*$L INFOPLUS*)
{$ENDIF}
{$F-}

end.
